#include "EntityCommandManager.h"

namespace SimulationEngine
{

EntityCommandManager *EntityCommandManager::instance = 0;

EntityCommandManager::EntityCommandManager()
{
}

EntityCommandManager *EntityCommandManager::GetInstance()
{
	if (instance==0)
		instance =  new EntityCommandManager();
	return instance;
}

list<DataParameter*> EntityCommandManager::ExecuteEntityCommand(int entityid, string commandkey, list<DataParameter*> data)
{
	EntityManager *entitymanager = EntityManager::GetInstance();
	ISimEntity *entity = entitymanager->GetEntity(entityid);
	if (entity!=0)
	{
		ICommand *toexecute = entity->GetCommand(commandkey);
		return toexecute->execute(data);
	}
	else
	{
		list<DataParameter*> resp;
		return resp;
	}
		
}

}
